package com.ejie.aa17a.view.pdf;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.servlet.view.document.AbstractPdfView;

import com.ejie.aa17a.informes.Aa17aInformesPDF;
import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.model.Aa17aDatoHorario;
import com.ejie.aa17a.model.Aa17aInformeFiltro;
import com.ejie.aa17a.utilidades.Aa17aConstantes;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfWriter;

/**
 * Aa17aPdfNotificacionPapel
 * 
 * @author Francisco.Galvez
 * 
 */
public class Aa17aPDFView extends AbstractPdfView {

	/**
	 * 
	 */
	public Aa17aPDFView() {

	}

	//
	private ReloadableResourceBundleMessageSource viewsMessageSource;

	/**
	 * buildPdfDocument
	 * 
	 * @param model
	 *            Map<String, Object>
	 * @param document
	 *            Document
	 * @param writer
	 *            PdfWriter
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * 
	 * @throws Exception
	 *             exception
	 * 
	 */
	protected void buildPdfDocument(Map<String, Object> model,
					Document document, PdfWriter writer, HttpServletRequest request,
					HttpServletResponse response) throws Exception {

		try {

			Aa17aInformesPDF informesPDF = new Aa17aInformesPDF(this.viewsMessageSource.getParentMessageSource());

			Integer tipoInforme = (Integer) model.get("tipoInforme");
			Aa17aInformeFiltro informeFiltro = (Aa17aInformeFiltro) model.get("filtro");

			if (Aa17aConstantes.INFORME_DATOS_HORARIOS.equals(tipoInforme)) {
				@SuppressWarnings(value = "unchecked")
				List<Aa17aDatoHorario> listDatosHorarios = (List<Aa17aDatoHorario>) model.get("datos");
				informesPDF.informeDatosHorarios(document, listDatosHorarios, informeFiltro);
			}
			else if (Aa17aConstantes.INFORME_DATOS_HISTORICOS_DIARIO.equals(tipoInforme)) {
				@SuppressWarnings(value = "unchecked")
				List<Aa17aDatoHistorico> listDatosHistoricos = (List<Aa17aDatoHistorico>) model.get("datos");
				informesPDF.informeHistoricoDatosDiarios(document, listDatosHistoricos, informeFiltro);

			}
			else if (Aa17aConstantes.INFORME_DATOS_HISTORICOS_HORARIO.equals(tipoInforme)) {
				@SuppressWarnings(value = "unchecked")
				List<Aa17aDatoHorario> listDatosHorarios = (List<Aa17aDatoHorario>) model.get("datos");
				informesPDF.informeHistoricoDatosHorarios(document, listDatosHorarios, informeFiltro);

			}

		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * @param viewsMessageSource
	 *            the viewsMessageSource to set
	 */
	public void setViewsMessageSource(ReloadableResourceBundleMessageSource viewsMessageSource) {
		this.viewsMessageSource = viewsMessageSource;
	}

	/**
	 * @return the viewsMessageSource
	 */
	public ReloadableResourceBundleMessageSource getViewsMessageSource() {
		return this.viewsMessageSource;
	}

}